using System;
using System.Reflection;
using System.Resources;
using System.Collections.Generic;
using System.Text;

namespace AssemblyDemo2
{
   class Program
   {
      static void Main(string[] args)
      {
         Assembly a = Assembly.GetExecutingAssembly();
         Console.WriteLine("Biecy zestaw '{0}' zosta zaadowany z '{1}'",
            a.GetName().Name, a.Location);
         Console.WriteLine("\nWczytany z globalnego bufora zestaww (GAC)? {0}",
            a.GlobalAssemblyCache ? "Tak" : "Nie");
         Console.WriteLine(
            "Zestaw ten wymaga co najmniej wersji Framework {0} (wersja kompilacji zestawu)",
            a.ImageRuntimeVersion);

         Assembly otherAssembly = Assembly.LoadFile(
            AppDomain.CurrentDomain.BaseDirectory + "\\PrzykadowyZestaw.DLL");
         Console.WriteLine("Inny zestaw: {0}", otherAssembly.GetName().Name);
         Console.WriteLine("Typy zawarte w '{0}':", otherAssembly.GetName().Name);
         foreach (Type t in otherAssembly.GetTypes())
         {
            Console.WriteLine(t.Name);
         }


         Console.ReadLine();
      }
   }
}
